<?php
declare(strict_types=1);
namespace App\Http;

final class Request
{
    public static function method(): string { return $_SERVER['REQUEST_METHOD'] ?? 'GET'; }
    public static function path(): string {
        $uri = $_SERVER['REQUEST_URI'] ?? '/';
        $qpos = strpos($uri, '?');
        if ($qpos !== false) $uri = substr($uri, 0, $qpos);
        return rtrim($uri, '/') ?: '/';
    }
    public static function json(): array {
        $raw = file_get_contents('php://input') ?: '';
        $data = json_decode($raw, true);
        return is_array($data) ? $data : [];
    }
    public static function header(string $name): ?string {
        $key = 'HTTP_' . strtoupper(str_replace('-', '_', $name));
        return $_SERVER[$key] ?? null;
    }
}
