<?php
declare(strict_types=1);
namespace App\Support;

final class Logger
{
    private static function write(string $level, string $message, array $context = []): void {
        $dir = __DIR__ . '/../../storage/logs';
        if (!is_dir($dir)) @mkdir($dir, 0775, true);
        $file = $dir . '/app-' . date('Y-m-d') . '.log';
        $line = json_encode([
            'ts' => date('c'),
            'level' => $level,
            'message' => $message,
            'context' => $context,
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        @file_put_contents($file, $line . PHP_EOL, FILE_APPEND);
    }

    public static function info(string $message, array $context = []): void { self::write('info', $message, $context); }
    public static function error(string $message, array $context = []): void { self::write('error', $message, $context); }
    public static function audit(string $action, array $context = []): void { self::write('audit', $action, $context); }
}
