<?php
declare(strict_types=1);

// Minimal front controller / router for cPanel shared hosting.
// Point your domain/subdomain "Document Root" to /public

require_once __DIR__ . '/../app/bootstrap.php';

use App\Http\Router;
use App\Http\Response;

$router = new Router();

// Health
$router->get('/health', function () {
    return Response::json(['ok' => true, 'ts' => date('c')]);
});

// Public auth endpoints (example)
$router->post('/api/auth/login', [App\Controllers\AuthController::class, 'login']);
$router->post('/api/auth/register', [App\Controllers\AuthController::class, 'register']);

// Accounts (example)
$router->get('/api/accounts', [App\Controllers\AccountController::class, 'list']);
$router->post('/api/accounts', [App\Controllers\AccountController::class, 'create']);

// Transfers & payments (example)
$router->post('/api/transfers', [App\Controllers\TransferController::class, 'create']);
$router->post('/api/payment-links', [App\Controllers\PaymentLinkController::class, 'create']);

// Webhook receiver from providers (OpenPass / others)
$router->post('/webhooks/openpass', [App\Controllers\WebhookController::class, 'openpass']);

// Admin (simple)
$router->get('/admin', [App\Controllers\AdminController::class, 'dashboard']);

$router->dispatch();
